package com.esv.datacenter.iot.module.devicemodel.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.datacenter.iot.module.datamodel.entity.DataModelEntity;
import com.esv.datacenter.iot.module.devicemodel.dao.DeviceDataMapDao;
import com.esv.datacenter.iot.module.devicemodel.entity.DeviceDataMapEntity;
import com.esv.datacenter.iot.module.devicemodel.service.DeviceDataMapService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;


@Service("deviceDataMapService")
public class DeviceDataMapServiceImpl extends ServiceImpl<DeviceDataMapDao, DeviceDataMapEntity> implements DeviceDataMapService {

    @Override
    public int getCountByDataModelId(Long dataModelId) {
        return this.getBaseMapper().selectCount(new LambdaQueryWrapper<DeviceDataMapEntity>()
                .eq(DeviceDataMapEntity::getDataModelId, dataModelId));
    }

    @Override
    public void deleteByDeviceTypeId(Long deviceTypeId) {
        this.getBaseMapper().delete(new LambdaQueryWrapper<DeviceDataMapEntity>()
                .eq(DeviceDataMapEntity::getDeviceTypeId, deviceTypeId));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveDeviceDataMap(Long deviceTypeId, String dataModelIds) {
        this.getBaseMapper().delete(new LambdaQueryWrapper<DeviceDataMapEntity>().eq(DeviceDataMapEntity::getDeviceTypeId, deviceTypeId));

        if (Objects.nonNull(StringUtils.trimToNull(dataModelIds))) {
            String[] dataModelIdList = dataModelIds.split(",");
            for (String dataModelId : dataModelIdList) {
                DeviceDataMapEntity entity = new DeviceDataMapEntity();
                entity.setDeviceTypeId(deviceTypeId);
                entity.setDataModelId(Long.parseLong(dataModelId));
                this.getBaseMapper().insert(entity);
            }
        }
    }

    @Override
    public List<DataModelEntity> getDataModelByDeviceTypeId(Long deviceTypeId) {
        DeviceDataMapEntity entity = new DeviceDataMapEntity();
        entity.setDeviceTypeId(deviceTypeId);
        return this.getBaseMapper().selectDataModelByDeviceTypeId(entity);
    }
}