package com.esv.datacenter.iot.module.omodel.form;

import com.esv.datacenter.iot.common.validator.groups.ValidatorInsert;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/07/31 13:47
 * @version:1.0
 */
@Data
public class ObjectModelForm {

    /**
     *
     */
    private Long id;
    /**
     * 模型名称
     */
    @Length(max = 50, message = "[模型名称]长度不合法", groups = {ValidatorInsert.class})
    @NotBlank(message = "[模型名称]不能为空", groups = {ValidatorInsert.class})
    private String name;
    /**
     * 模型描述
     */
    @Length(max = 200, message = "[模型描述]长度不合法", groups = {ValidatorInsert.class})
    @NotBlank(message = "[模型描述]不能为空", groups = {ValidatorInsert.class})
    private String description;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
