package com.esv.datacenter.iot.module.datamodel.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.datacenter.iot.module.datamodel.entity.DataModelPropertyEntity;
import com.esv.datacenter.iot.module.datamodel.form.DataModelPropertyForm;
import com.esv.datacenter.iot.module.datamodel.vo.DataModelPropertyVO;

import java.util.List;

/**
 * 数据模型属性表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-07-31 13:35:49
 */
public interface DataModelPropertyService extends IService<DataModelPropertyEntity> {

    /**
     * @description 逻辑删除指定模型的所有属性
     * @param entity:
     * @return java.lang.Integer
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 13:28
     **/
    Integer logicDeleteModelProperty(DataModelPropertyEntity entity);

    /**
     * @description 获取指定模型的属性列表
     * @param modelId:
     * @return java.util.List<com.esv.datacenter.iot.module.dmodel.vo.ModelPropertyVO>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 14:32
     **/
    List<DataModelPropertyVO> getModelPropertyList(Long modelId);

    /**
     * @description 保存模型属性
     * @param modelId:
     * @param propertyList:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 14:42
     **/
    void saveModelProperty(Long modelId, List<DataModelPropertyForm> propertyList);

    /**
     * @description 校验属性
     * @param propertyList:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/03 19:59
     **/
    void checkModelProperty(List<DataModelPropertyForm> propertyList);

    /**
     * @description 属性代码转换为小写
     * @param propertyList:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/03 20:40
     **/
    void propertyCode2Lowercase(List<DataModelPropertyForm> propertyList);

}

