package com.esv.datacenter.iot.module.omodel.form;

import com.esv.datacenter.iot.common.validator.groups.*;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/07/31 13:47
 * @version:1.0
 */
@Data
public class ObjectModelForm {

    /**
     *
     */
    @NotNull(message = "[模型ID]不能为空", groups = {ValidatorDetail.class, ValidatorUpdate.class, ValidatorDelete.class})
    private Long id;
    /**
     * 租户ID
     */
    private Long tenantId;
    /**
     * 部门ID
     */
    private Long departmentId;
    /**
     * 模型名称
     */
    @Length(max = 50, message = "[模型名称]长度不合法", groups = {ValidatorInsert.class, ValidatorList.class, ValidatorUpdate.class})
    @NotBlank(message = "[模型名称]不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String name;
    /**
     * 模型描述
     */
    @Length(max = 200, message = "[模型描述]长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "[模型描述]不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String description;

    /**
     * 模型属性
     */
    @NotNull(message = "[模型属性]不能为空", groups = {ValidatorInsert.class})
    private List<ModelPropertyForm> propertyList;

    /**
     * 页码
     **/
    @Range(min = 1, max = 65535, message = "无效的pageNum", groups = {ValidatorList.class})
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Integer pageNum;
    /**
     * 每页记录条数
     **/
    @Range(min = 1, max = 100, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Integer pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
