package com.esv.datacenter.iot.module.omodel.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.datacenter.iot.common.em.DbDeletedEnum;
import com.esv.datacenter.iot.module.omodel.dao.ObjectModelInstanceDao;
import com.esv.datacenter.iot.module.omodel.entity.ObjectModelInstanceEntity;
import com.esv.datacenter.iot.module.omodel.service.ObjectModelInstanceService;
import com.esv.datacenter.iot.module.omodel.vo.ModelInstanceVO;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;


@Service("objectModelInstanceService")
public class ObjectModelInstanceServiceImpl extends ServiceImpl<ObjectModelInstanceDao, ObjectModelInstanceEntity> implements ObjectModelInstanceService {

    @Override
    public List<ModelInstanceVO> getModelInstanceList(Long modelId) {
        List<ObjectModelInstanceEntity> entityList = this.getBaseMapper().selectList(new LambdaQueryWrapper<ObjectModelInstanceEntity>()
                .eq(ObjectModelInstanceEntity::getDeleted, DbDeletedEnum.NO.getCode())
                .eq(ObjectModelInstanceEntity::getModelId, modelId)
                .orderByAsc(ObjectModelInstanceEntity::getInstanceName));
        List<ModelInstanceVO> voList = new ArrayList<>();
        for (ObjectModelInstanceEntity entity : entityList) {
            ModelInstanceVO vo = new ModelInstanceVO();
            BeanUtils.copyProperties(entity, vo);
            vo.setCreateTime(entity.getCreateTime().getTime());
            vo.setUpdateTime(entity.getUpdateTime().getTime());
            voList.add(vo);
        }

        return voList;
    }
}