package com.esv.datacenter.iot.module.omodel.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.datacenter.iot.common.vo.PageResultVO;
import com.esv.datacenter.iot.module.omodel.entity.ObjectModelEntity;
import com.esv.datacenter.iot.module.omodel.form.ObjectModelForm;
import com.esv.datacenter.iot.module.omodel.vo.ModelDetailVO;
import com.esv.datacenter.iot.module.omodel.vo.ModelVO;

import java.util.List;

/**
 * 物模型表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-07-31 13:35:49
 */
public interface ObjectModelService extends IService<ObjectModelEntity> {

    /**
     * @description 创建模型
     * @param form:
     * @return java.lang.Long
     * @author huangChaobin@esvtek.com
     * @createTime 2020/07/31 13:52
     **/
    Long createObjectModel(ObjectModelForm form);

    /**
     * @description 分页查询模型列表
     * @param queryObj:
     * @return com.esv.datacenter.iot.common.vo.PageResultVO
     * @author huangChaobin@esvtek.com
     * @createTime 2020/07/31 16:26
     **/
    PageResultVO getModel4Page(ObjectModelForm queryObj);

    /**
     * @description 获取模型详情
     * @param form:
     * @return com.esv.datacenter.iot.module.omodel.vo.ModelDetailVO
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 10:25
     **/
    ModelDetailVO getModelDetail(ObjectModelForm form);
    
    /**
     * @description 更新模型
     * @param form: 
     * @return java.lang.Integer
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 10:48
     **/
    Integer updateModel(ObjectModelForm form);

    /**
     * @description 模型实例数
     * @param modelId:
     * @return java.lang.Integer
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 11:29
     **/
    Integer modelInstanceCount(Long modelId);

    /**
     * @description 删除模型
     * @param modelId:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 11:33
     **/
    void deleteModel(Long modelId);

    /**
     * @description 获取所有模型列表
     * @return java.util.List<com.esv.datacenter.iot.module.omodel.vo.ModelVO>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 13:04
     **/
    List<ModelVO> getAllModeList();

    /**
     * @description 判断模型是否存在
     * @param modelId:
     * @return java.lang.Boolean
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 14:19
     **/
    Boolean isModelExits(Long modelId);

}

