package com.esv.superhive.gateway.util;

import com.esv.superhive.gateway.common.constants.CommonConstants;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

import java.util.UUID;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/07/21 18:41
 * @version:1.0
 */
public class LogUtils {

    /**
     * @description 获取当前线程设置日志traceId
     * @return String
     * @author huangChaobin@esvtek.com
     * @createTime 2020/07/21 18:43
     **/
    public static String getThreadTraceId() {
        String traceId = MDC.get(CommonConstants.LOG_TRACE_ID);
        if (StringUtils.isBlank(traceId)) {
            traceId = UUID.randomUUID().toString().replaceAll("-", "");
        }
        return traceId;
    }

}
