package com.esv.superhive.gateway.common.response;

import com.esv.superhive.gateway.util.LogUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * @description:
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/24 14:42
 * @version:1.0
 */
public class EResponse<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    private int code;

    private String message;

    private long responseTime;

    private String logId;

    private T data;

    private EResponse() {
        this.responseTime = System.currentTimeMillis();
        this.logId = LogUtils.getThreadTraceId();
    }

    private EResponse(int code, String message) {
        this();
        this.code = code;
        this.message = message;
    }

    private EResponse(int code, String message, T data) {
        this();
        this.code = code;
        this.message = message;
        this.data = data;
    }

    private EResponse(ECode eCode) {
        this(eCode.code(), eCode.message());
    }

    private EResponse(T data) {
        this(ECode.SUCCESS);
        this.data = data;
    }

    /**
     * description 成功返回
     * param []
     * return com.esv.common.response.EResponse
     * author chenfm
     * createTime 2020/3/6 14:50
     **/
    public static EResponse ok() {
        return new EResponse(ECode.SUCCESS);
    }

    /**
     * description 成功返回(带数据)
     * param [data] 返回数据
     * return com.esv.common.response.EResponse<T>
     * author chenfm
     * createTime 2020/3/6 14:50
     **/
    public static<T> EResponse<T> ok(T data) {
        return new EResponse<T>(data);
    }

    /**
     * description 返回默认系统异常
     * param []
     * return com.esv.springcloud.template.common.response.EResponse
     * author Administrator
     * createTime 2020/03/13 15:36
     **/
    public static EResponse error() {
        return error(ECode.SERVER_ERROR);
    }

    /**
     * description 返回自定义code、message异常
     * param []
     * return com.esv.common.response.EResponse
     * author chenfm
     * createTime 2020/3/9 13:32
     *
     * @param code
     * @param message*/
    public static EResponse error(int code, String message) {
        return new EResponse(code, message);
    }

    /**
     * description 返回自定义code、message、data异常
     * param [code, message, data]
     * return com.esv.htwl.customer.common.response.EResponse<T>
     * author HuangChaobin
     * createTime 2020/07/09 15:04
     **/
    public static<T> EResponse<T> error(int code, String message, T data) {
        return new EResponse(code, message, data);
    }

    /**
     * description 异常返回
     * param [rCode] 异常码
     * return com.esv.common.response.EResponse
     * author chenfm
     * createTime 2020/3/6 14:50
     **/
    public static EResponse error(ECode eCode) {
        return new EResponse(eCode);
    }

    /**
     * description 判断返回是否成功
     * param []
     * return boolean
     * author chenfm
     * createTime 2020/3/6 14:51
     **/
    public boolean success() {
        return this.code == ECode.SUCCESS.code();
    }

    /**
     * description 修改提示信息
     * param [message] 提示信息
     * return void
     * author chenfm
     * createTime 2020/3/6 17:44
     **/
    public EResponse message(String message) {
        this.message = message;
        return this;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public long getResponseTime() {
        return responseTime;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    public String getLogId() {
        return logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}