package com.esv.superhive.gateway.common.exception;

/**
 * @description:
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/24 14:41
 * @version:1.0
 */
public class EException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    private String msg;
    private int code = 500;

    public EException(String msg) {
        super(msg);
        this.msg = msg;
    }

    public EException(String msg, Throwable e) {
        super(msg, e);
        this.msg = msg;
    }

    public EException(String msg, int code) {
        super(msg);
        this.msg = msg;
        this.code = code;
    }

    public EException(String msg, int code, Throwable e) {
        super(msg, e);
        this.msg = msg;
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

}
