package com.esv.superhive.gateway.common.constants;

/**
 * @description: 全局常量
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/07/17 16:17
 * @version:1.0
 */
public class CommonConstants {

    /**
     * 操作系统：windows
     **/
    public static final String SYSTEM_WINDOWS = "windows";

    /**
     * 访问端来源：1-浏览器端、2-Android端、3-iOS端、4-后台服务端
     **/
    public static final String REQ_SOURCE_TYPE_KEY = "Source-Type";
    public static final String REQ_SOURCE_TYPE_WEB = "1";
    public static final String REQ_SOURCE_TYPE_ANDROID = "2";
    public static final String REQ_SOURCE_TYPE_IOS = "3";
    public static final String REQ_SOURCE_TYPE_SERVICE = "4";

    /**
     * Feign调用返回参数
     **/
    public static final String FEIGN_RESULT_CODE = "code";
    public static final String FEIGN_RESULT_MESSAGE = "message";
    public static final String FEIGN_RESULT_DATA = "data";
    public static final int FEIGN_RESULT_SUCCESS = 200;

    /**
     * 日志ID
     **/
    public static final String LOG_TRACE_ID = "traceId";

    /**
     * 字符串"null"
     **/
    public static final String NULL_STRING = "null";

    /**
     * 字符串"unknown"
     **/
    public static final String UNKNOWN_STRING = "unknown";

    /**
     * 默认字符编码
     **/
    public static final String DEFAULT_CHARACTER_ENCODING = "utf-8";

    /**
     * Http请求方式
     **/
    public static final String HTTP_REQUEST_METHOD_GET = "GET";
    public static final String HTTP_REQUEST_METHOD_POST = "POST";

    /**
     * Http请求头
     **/
    public static final String HTTP_HEADER_X_FORWARDED_FOR = "x-forwarded-for";
    public static final String HTTP_HEADER_PROXY_CLIENT_IP = "Proxy-Client-IP";
    public static final String HTTP_HEADER_WL_PROXY_CLIENT_IP = "WL-Proxy-Client-IP";
}
