package com.esv.datacenter.gateway.filter;

import com.esv.datacenter.gateway.common.constants.CommonConstants;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;

import java.util.UUID;

/**
 * @description:
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/29 19:48
 * @version:1.0
 */
@Slf4j
public class LogBackPreFilter extends ZuulFilter {
    
    /**
     * pre：主要用在路由映射的阶段是寻找路由映射表的
     * route:具体的路由转发过滤器是在routing路由器，具体的请求转发的时候会调用
     * error:一旦前面的过滤器出错了，会调用error过滤器
     * post:当routing，error运行完后才会调用该过滤器，是在最后阶段
     *
     **/
    @Override
    public String filterType() {
        return "pre";
    }

    /**
     * 自定义过滤器执行的顺序，数值越大越靠后执行，越小就越先执行
     **/
    @Override
    public int filterOrder() {
        return -10;
    }

    /**
     * 控制过滤器生效不生效（是否执行run()方法），可以在里面写一串逻辑来控制,true是生效
     **/
    @Override
    public boolean shouldFilter() {
        return true;
    }

    @Override
    public Object run() throws ZuulException {
        RequestContext context = RequestContext.getCurrentContext();

        String traceId = UUID.randomUUID().toString().replace("-", "");
        MDC.put(CommonConstants.LOG_TRACE_ID, traceId);
        context.addZuulRequestHeader("gateway_traceid", traceId);

        return null;
    }
}
