package com.esv.flink.bean;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;

/**
 * @description:
 * @project: my-flink-project
 * @name: com.esv.flink.bean.EmqData
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/8/3 15:28
 * @version: 1.0
 */
@Data
public class EmqData {

    private long modelId;

    private long deviceId;

    private String topic;

    private long reportTime;

    private JSONObject jsonObject;

    private int count;

    public EmqData() {

    }

    public EmqData(String topic, String content, int count) {
        this.topic = topic;
        this.count = count;
        this.modelId = Long.parseLong(topic.split("/")[2]);
        this.deviceId = Long.parseLong(topic.split("/")[3]);

        this.jsonObject = JSON.parseObject(content);
        long timestamp;
        if (jsonObject.containsKey("time")) {
            timestamp = Long.parseLong(jsonObject.get("time").toString());
            jsonObject.remove("time");
        } else {
            timestamp = System.currentTimeMillis();
        }
        this.reportTime = timestamp;
    }

    @Override
    public String toString() {
        return "EmqData{" +
                "topic='" + topic + '\'' +
                ", content='" + jsonObject.toString() + '\'' +
                ", count=" + count +
                '}';
    }
}
