package com.esv.flink;

import lombok.extern.slf4j.Slf4j;
import org.fusesource.mqtt.client.FutureConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;

import java.util.Properties;

/**
 * @description:
 * @project: emqdemo
 * @name: com.esv.flink.EmqClient
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/7/30 15:52
 * @version: 1.0
 */
@Slf4j
public class EmqClient {

    private String broker;
    private String subTopic;
    private String clientId;
    private String username;
    private String password;

    public EmqClient(Properties properties) {
        this.broker = properties.getProperty("mqtt.host");
        this.subTopic = properties.getProperty("mqtt.subscribe.topic");
        this.clientId = properties.getProperty("mqtt.client.id");
        this.username = properties.getProperty("mqtt.username");
        this.password = properties.getProperty("mqtt.password");
    }

    public FutureConnection run () {
        try {
            MQTT mqtt = new MQTT();
            mqtt.setHost(broker);
            mqtt.setCleanSession(true);
            mqtt.setReconnectAttemptsMax(6);
            mqtt.setReconnectDelay(2000);
            mqtt.setKeepAlive((short) 30);
            mqtt.setSendBufferSize(64);
            mqtt.setClientId(clientId);
            mqtt.setUserName(username);
            mqtt.setPassword(password);

            Topic[] topics = {
                    new Topic(subTopic, QoS.AT_MOST_ONCE)
            };

            FutureConnection connection = mqtt.futureConnection();
            connection.connect();
            connection.subscribe(topics);
            log.info("mqtt连接成功: {}", broker);

            return connection;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return null;
    }

}
