package com.esv.flink.bean;

import lombok.Data;

import java.sql.Timestamp;

/**
 * @description:
 * @project: my-flink-project
 * @name: com.esv.flink.bean.DeviceDataAlarm
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/8/7 10:01
 * @version: 1.0
 */
@Data
public class DeviceDataAlarm {

    public DeviceDataAlarm() {

    }

    public DeviceDataAlarm(long deviceId, long alarmRuleId, Timestamp reportTime) {
        this.deviceId = deviceId;
        this.alarmRuleId = alarmRuleId;
        this.reportTime = reportTime;
        this.alarmTime = new Timestamp(System.currentTimeMillis());
    }

    /**
     * description 设备id
     * author chenfm
     * createTime 2020/8/7 10:02
     **/
    private long deviceId;
    /**
     * description 告警规则id
     * author chenfm
     * createTime 2020/8/7 10:02
     **/
    private long alarmRuleId;
    /**
     * description 上报值
     * author chenfm
     * createTime 2020/8/7 15:22
     **/
    private String reportValue;
    /**
     * description 数据上报时间
     * author chenfm
     * createTime 2020/8/7 10:02
     **/
    private Timestamp reportTime;
    /**
     * description 告警时间
     * author chenfm
     * createTime 2020/8/7 10:02
     **/
    private Timestamp alarmTime;

}
