package com.esv.freight.file.module.file.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @description: 文件类型枚举
 * @project: freight-file-service
 * @name: com.esv.freight.file.module.file.constants.FileTypeEnum
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/15 11:20
 * @version:1.0
 */
public enum FileTypeEnum {

    UNDEFINED("undefined", "text/plain"),
    TXT("txt", "text/plain"),
    IMAGE("image", "application/x-jpg"),
    PDF("pdf", "application/pdf"),
    EXCEL("excel", "application/vnd.ms-excel"),
    WORD("word", "application/application/msword"),
    APK("apk", "application/vnd.android.package-archive");

    private String fileType;
    private String contentType;

    FileTypeEnum(String fileType, String contentType) {
        this.fileType = fileType;
        this.contentType = contentType;
    }

    public static FileTypeEnum getEnumByType(String fileType) {
        if (StringUtils.isBlank(fileType)){
            return FileTypeEnum.UNDEFINED;
        }
        for (FileTypeEnum typeEnum : FileTypeEnum.values()) {
            if (typeEnum.getFileType().equals(fileType)) {
                return typeEnum;
            }
        }
        return FileTypeEnum.UNDEFINED;
    }

    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}
