package com.esv.freight.file.common.util;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

/**
 * @description: 文件工具类
 * @project: freight-file-service
 * @name: com.esv.freight.file.common.util.FileUtils
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/10 11:14
 * @version:1.0
 */
public class FileUtils {

    /**
     * description 校验是否有效图片
     * param [input]
     * return boolean
     * author HuangChaobin
     * createTime 2020/06/10 11:29
     **/
    public static boolean isValidImage(InputStream input) {
        boolean isValid = false;
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(input);
        } catch (IOException e) {
            return isValid;
        }
        if (null == bufferedImage) {
            isValid = false;
        } else {
            isValid = true;
        }
        return isValid;
    }

    /**
     * description 校验是否有效图片
     * param [bytes]
     * return boolean
     * author HuangChaobin
     * createTime 2020/06/10 11:30
     **/
    public static boolean isValidImage(byte[] bytes) {
        return isValidImage(new ByteArrayInputStream(bytes));
    }

    /**
     * description 校验是否有效图片
     * param [file]
     * return boolean
     * author HuangChaobin
     * createTime 2020/06/10 11:39
     **/
    public static boolean isValidImage(File file) {
        InputStream inputStream;
        try {
            inputStream = org.apache.commons.io.FileUtils.openInputStream(file);
        } catch (IOException e) {
            return false;
        }
        return isValidImage(inputStream);
    }

}
