package com.esv.freight.file.module.upload.form;

import com.esv.freight.file.common.validator.groups.ValidatorDelete;
import com.esv.freight.file.common.validator.groups.ValidatorInsert;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @description:
 * @project: freight-file-service
 * @name: com.esv.freight.file.module.upload.form.FileForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/14 14:03
 * @version:1.0
 */
@Data
public class FileForm {

    @Length(max = 2, message = "参数fileType长度不合法", groups = {ValidatorInsert.class})
    @NotBlank(message = "参数fileType不能为空", groups = {ValidatorInsert.class})
    private String fileType;

    @NotBlank(message = "参数fileData不能为空", groups = {ValidatorInsert.class})
    private String fileData;

    @Length(max = 50, message = "参数fileName长度不合法", groups = {ValidatorInsert.class})
    @NotBlank(message = "参数fileName不能为空", groups = {ValidatorInsert.class})
    private String fileName;

    @Length(max = 64, message = "参数id长度不合法", groups = {ValidatorDelete.class})
    @NotBlank(message = "参数id不能为空", groups = {ValidatorDelete.class})
    private String id;
}
