package com.esv.freight.file.module.file.controller;

import com.esv.freight.file.common.exception.EException;
import com.esv.freight.file.common.response.ECode;
import com.esv.freight.file.common.response.EResponse;
import com.esv.freight.file.common.validator.groups.ValidatorInsert;
import com.esv.freight.file.module.file.form.FileForm;
import com.esv.freight.file.module.file.form.WaterMarkForm;
import com.esv.freight.file.module.file.service.FileMetaService;
import com.esv.freight.file.module.file.service.FileService;
import com.esv.freight.file.module.file.service.WatermarkService;
import com.esv.freight.file.module.file.vo.FileVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 水印图片合成Controller
 * @project: freight-file-service
 * @name: com.esv.freight.file.module.file.controller.WatermarkController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/28 14:48
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/upload")
@RefreshScope
public class WatermarkController {

    private FileMetaService fileMetaService;
    private FileService fileService;
    private WatermarkService watermarkService;

    @Autowired
    public WatermarkController(FileMetaService fileMetaService, FileService fileService,
                               WatermarkService watermarkService) {
        this.fileMetaService = fileMetaService;
        this.fileService = fileService;
        this.watermarkService = watermarkService;
    }

    /**
     * description 图片水印合成
     * param [form]
     * return com.esv.freight.file.common.response.EResponse
     * author HuangChaobin
     * createTime 2020/05/28 14:58
     **/
    @PostMapping("/imageWithWatermark")
    public EResponse imageWithWatermark(@RequestBody @Validated(ValidatorInsert.class) WaterMarkForm form) throws EException {
        // 校验文件类型及大小
        FileForm fileForm = new FileForm();
        fileForm.setFileType("image");
        fileForm.setFileData(form.getFileData());
        fileForm.setFileName(form.getFileName());
        fileService.checkFile(fileForm);

        // 校验是否有效图片
        fileService.checkIsImage(form.getFileData());

        // 添加水印
        try {
            watermarkService.addWatermark2Image(form);
        } catch (Exception e) {
            log.error("图片添加文字时发生错误：{}", e.getMessage(), e);
            throw new EException(ECode.SERVER_ERROR.code(), ECode.SERVER_ERROR.message());
        }

        // 保存文件及元信息
        fileForm.setFileData(form.getFileData());
        FileVO vo = fileMetaService.uploadFile(fileForm);

        return EResponse.ok(vo);
    }
}
