package com.esv.freight.file.module.file.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 文件元数据表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-14 13:31:47
 */
@Data
@TableName("base_file_meta")
public class FileMetaEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 调用文件服务的系统
	 */
	private String callSystem;
	/**
	 * 文件id
	 */
	private String fileId;
	/**
	 * 文件大小，单位B
	 */
	private Long fileSize;
	/**
	 * 文件名
	 */
	private String fileName;
	/**
	 * 文件类型：image、pdf、excel、apk等
	 */
	private String fileType;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 是否删除：0-未删除、1-已删除
	 */
	@TableLogic
	private Boolean deleted;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 删除时间
	 */
	private Date deleteTime;

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
	}

}
