package com.esv.freight.file.common.component;

import com.baidu.aip.ocr.AipOcr;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

/**
 * @description: 百度智能云AipOcr组件
 * @project: freight-file-service
 * @name: com.esv.freight.file.common.component.AipOcrComponent
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/15 9:35
 * @version:1.0
 */
@Component
@RefreshScope
public class AipOcrComponent {

    @Value("${baidu.ocr.app_id}")
    private String APP_ID;

    @Value("${baidu.ocr.api_key}")
    private String API_KEY;

    @Value("${baidu.ocr.secret_key}")
    private String SECRET_KEY;

    private static AipOcr client;

    public AipOcr getClient() {
        if (null == client) {
            System.out.println("APP_ID="+APP_ID);
            System.out.println("API_KEY="+API_KEY);
            System.out.println("SECRET_KEY="+SECRET_KEY);
            client = new AipOcr(APP_ID, API_KEY, SECRET_KEY);
        }
        return client;
    }
}
