package com.esv.freight.file.module.file.service.impl;

import com.esv.freight.file.module.file.form.WaterMarkForm;
import com.esv.freight.file.module.file.service.WatermarkService;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Base64;

/**
 * @description:
 * @project: freight-file-service
 * @name: com.esv.freight.file.module.file.service.impl.WatermarkServiceImpl
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/28 16:01
 * @version:1.0
 */
@Service("watermarkService")
public class WatermarkServiceImpl implements WatermarkService {

    private static final String DEFAULT_FONT_PATH = "/font/迷你简大黑.TTF";

    @Override
    public void addWatermark2Image(WaterMarkForm form) throws Exception {
        byte[] bytes = Base64.getDecoder().decode(form.getFileData());
        Image image = ImageIO.read(new ByteArrayInputStream(bytes));
        int imgWidth = image.getWidth(null);
        int imgHeight = image.getHeight(null);
        BufferedImage bufImg = new BufferedImage(imgWidth, imgHeight, BufferedImage.TYPE_INT_RGB);
        Graphics2D graphics2D = bufImg.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.drawImage(image, 0, 0, imgWidth, imgHeight, null);

        // 设置字体及颜色
        Font font = getDefaultFont(DEFAULT_FONT_PATH, Font.PLAIN, 30);
        graphics2D.setFont(font);
        Color color = new Color(255, 0, 0, 255);
        graphics2D.setColor(color);
        graphics2D.setColor(color);

        // 添加文字
        String[] texts = form.getText().split("\\|");
        int length = texts.length;
        for (int i = 0; i < length; i++) {
            graphics2D.drawString(texts[i], 30, imgHeight - (30 * (length - i) ));
        }
        graphics2D.dispose();

        // 输出图片
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write(bufImg, "JPG", outputStream);
        form.setFileData(Base64.getEncoder().encodeToString(outputStream.toByteArray()));
    }

    /**
     * description 获取自定义字体
     * param [fontPath, fontStyle, fontSize]
     * return java.awt.Font
     * author HuangChaobin
     * createTime 2020/05/28 17:49
     **/
    private static Font getDefaultFont(String fontPath, int fontStyle, int fontSize) throws Exception {
        InputStream inputStream = WatermarkServiceImpl.class.getResourceAsStream(fontPath);
        Font definedFont;
        try {
            definedFont = Font.createFont(Font.TRUETYPE_FONT, inputStream).deriveFont(fontStyle, fontSize);
        } catch (Exception e) {
            throw e;
        } finally {
            IOUtils.closeQuietly(inputStream);
        }
        return definedFont;
    }
}
