package com.esv.freight.file.module.file.controller;

import com.esv.freight.file.common.exception.EException;
import com.esv.freight.file.common.response.EResponse;
import com.esv.freight.file.common.validator.groups.ValidatorDelete;
import com.esv.freight.file.module.file.form.FileForm;
import com.esv.freight.file.module.file.service.FileMetaService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 文件删除Controller
 * @project: freight-file-service
 * @name: DeleteController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/14 19:37
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/delete")
public class DeleteController {

    private FileMetaService fileMetaService;

    public DeleteController(FileMetaService fileMetaService) {
        this.fileMetaService = fileMetaService;
    }

    @PostMapping("/single")
    public EResponse deleteSingleFile(@RequestBody @Validated(ValidatorDelete.class) FileForm fileForm) throws EException {
        fileMetaService.deleteFile(fileForm);
        return EResponse.ok();
    }
}
