package com.esv.freight.file.module.download;

import com.esv.freight.file.module.upload.service.FileMetaService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

/**
 * @description: 文件下载Controller
 * @project: freight-file-service
 * @name: com.esv.freight.file.module.download.DownloadController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/14 17:06
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/download")
public class DownloadController {

    private FileMetaService fileMetaService;

    @Autowired
    public DownloadController(FileMetaService fileMetaService) {
        this.fileMetaService = fileMetaService;
    }

    /**
     * description 文件下载
     * param [id, response]
     * return com.esv.freight.file.common.response.EResponse
     * author Administrator
     * createTime 2020/04/14 17:25
     **/
    @GetMapping("/direct/{id}")
    public void directDownload(@PathVariable("id") String id, HttpServletResponse response) {
        fileMetaService.directDownload(id, response);
    }
}
