package com.esv.freight.file.module.upload.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.file.common.exception.EException;
import com.esv.freight.file.module.upload.entity.FileMetaEntity;
import com.esv.freight.file.module.upload.form.FileForm;
import com.esv.freight.file.module.upload.vo.FileVO;

import javax.servlet.http.HttpServletResponse;

/**
 * 文件元数据表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-14 13:31:47
 */
public interface FileMetaService extends IService<FileMetaEntity> {

    /**
     * description 上传文件
     * param [fileForm]
     * return com.esv.freight.file.module.upload.vo.FileVO
     * author Administrator
     * createTime 2020/04/14 14:09
     **/
    FileVO uploadFile(FileForm fileForm) throws EException;

    /**
     * description 终端下载文件
     * param [id, response]
     * return void
     * author Administrator
     * createTime 2020/04/14 17:24
     **/
    void directDownload(String id, HttpServletResponse response);

    /**
     * description 文件删除
     * param [fileForm]
     * return void
     * author Administrator
     * createTime 2020/04/14 19:43
     **/
    void deleteFile(FileForm fileForm) throws EException;

    /**
     * description 获取文件数据
     * param [fileForm]
     * return java.lang.String
     * author Administrator
     * createTime 2020/04/14 20:23
     **/
    String getFileData(FileForm fileForm) throws EException;

}

