package com.esv.freight.file.module.upload.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.file.common.exception.EException;
import com.esv.freight.file.common.response.EResponse;
import com.esv.freight.file.common.validator.groups.ValidatorInsert;
import com.esv.freight.file.module.upload.form.FileForm;
import com.esv.freight.file.module.upload.service.FileMetaService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Base64;

/**
 * @description: 文件上传Controller
 * @project: freight-file-service
 * @name: com.esv.freight.file.module.upload.controller.UploadController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/14 13:36
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/upload")
@RefreshScope
public class UploadController {

    @Value("${file.register}")
    private String FILE_REGISTER;

    private FileMetaService fileMetaService;

    @Autowired
    public UploadController(FileMetaService fileMetaService) {
        this.fileMetaService = fileMetaService;
    }

    /**
     * description 上传单个文件
     * param [fileForm]
     * return com.esv.freight.file.common.response.EResponse
     * author Administrator
     * createTime 2020/04/14 15:09
     **/
    @PostMapping("/single")
    public EResponse uploadSingleFile(@RequestBody @Validated(ValidatorInsert.class) FileForm fileForm) throws EException {
        // 校验文件类型及大小
        checkFile(fileForm);

        return EResponse.ok(fileMetaService.uploadFile(fileForm));
    }

    /**
     * description 校验文件类型及大小
     * param []
     * return java.lang.Boolean
     * author Administrator
     * createTime 2020/04/14 14:57
     **/
    void checkFile(FileForm fileForm) throws EException {
        String[] types = FILE_REGISTER.trim().replaceAll("，", ",").split(",");
        String type;
        JSONObject fileTypeJson = new JSONObject();
        for (int i = 0; i < types.length; i++) {
            type = types[i];
            fileTypeJson.put(type.split("=")[0], Integer.parseInt(type.split("=")[1]));
        }

        // 校验文件类型
        String fileType = fileForm.getFileType();
        if (!fileTypeJson.containsKey(fileType)) {
            throw new EException(1001, "不支持的文件类型["+fileType+"]");
        }

        // 校验文件长度
        String fileData = fileForm.getFileData();
        byte[] bytes = Base64.getDecoder().decode(fileData);
        int fileRegSize = fileTypeJson.getIntValue(fileType);
        int fileMaxSize = fileRegSize * 1024 * 1024;
        if (fileMaxSize < bytes.length) {
            throw new EException(1002, "文件大小不能超过["+fileRegSize+"MB]");
        }
    }

}
