package com.esv.freight.file.module.file.form;

import com.esv.freight.file.common.validator.groups.ValidatorInsert;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @description:
 * @project: freight-file-service
 * @name: com.esv.freight.file.module.upload.form.WaterMarkForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/14 14:03
 * @version:1.0
 */
@Data
public class WaterMarkForm {

    @NotBlank(message = "参数fileData不能为空", groups = {ValidatorInsert.class})
    private String fileData;

    @Length(max = 50, message = "参数fileName长度不合法", groups = {ValidatorInsert.class})
    @NotBlank(message = "参数fileName不能为空", groups = {ValidatorInsert.class})
    private String fileName;

    @NotBlank(message = "参数text不能为空", groups = {ValidatorInsert.class})
    private String text;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
