package com.esv.freight.file.module.ocr.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.file.common.exception.EException;
import com.esv.freight.file.common.response.ECode;
import com.esv.freight.file.common.response.EResponse;
import com.esv.freight.file.module.ocr.form.IdCardForm;
import com.esv.freight.file.module.ocr.service.OcrHistoryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: Ocr Controller
 * @project: freight-file-service
 * @name: com.esv.freight.file.module.ocr.controller.OcrController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/15 10:24
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/ocr")
@RefreshScope
public class OcrController {

    private OcrHistoryService ocrHistoryService;

    @Autowired
    public OcrController(OcrHistoryService ocrHistoryService) {
        this.ocrHistoryService = ocrHistoryService;
    }

    /**
     * description 身份证正面识别
     * param []
     * return com.esv.freight.file.common.response.EResponse
     * author Administrator
     * createTime 2020/04/15 10:31
     **/
    @PostMapping("/idcard/front")
    public EResponse OcrIdCardFront(@RequestBody @Validated IdCardForm idCardForm) throws EException {
        // 参数校验
        if (idCardForm.isNeedFileInfo()) {
            if (null == idCardForm.getFileName()) {
                return EResponse.error(ECode.PARAM_ERROR.code(), "参数fileName不能为空");
            }
        }

        JSONObject data = ocrHistoryService.OcrIdCard(idCardForm);
        return EResponse.ok(data);
    }
}
