package com.esv.freight.file.module.ocr.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.file.BaseTestController;
import com.esv.freight.file.common.response.ECode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Base64;

/**
 * @description:
 * @project: freight-file-service
 * @name: com.esv.freight.file.module.ocr.controller.OcrControllerTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/15 13:53
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class OcrControllerTest extends BaseTestController {

    /**
     * OCR识别成功
     **/
    @Test
    public void a1_OcrIdCardFront_success_test() throws Exception {
        String url = "/ocr/idcard/front";
        JSONObject reqJson = new JSONObject();

        // 构造数据
        String filepath = "D:\\test\\idcard_front.jpg";
        File file = new File(filepath);
        InputStream input = new FileInputStream(file);
        reqJson.put("image", Base64.getEncoder().encodeToString(IOUtils.toByteArray(input)));
        reqJson.put("needFileInfo", false);

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("ocrInfo"));
    }

    /**
     * 参数错误
     **/
    @Test
    public void a2_OcrIdCardFront_params_error_test() throws Exception {
        String url = "/ocr/idcard/front";
        JSONObject reqJson = new JSONObject();

        // 构造数据
        String filepath = "D:\\test\\idcard_front.jpg";
        File file = new File(filepath);
        InputStream input = new FileInputStream(file);
        reqJson.put("image", Base64.getEncoder().encodeToString(IOUtils.toByteArray(input)));
        reqJson.put("needFileInfo", true);

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.PARAM_ERROR.code(), result.getIntValue("code"));
    }

    /**
     * OCR识别失败
     **/
    @Test
    public void a3_OcrIdCardFront_ocr_error_test() throws Exception {
        String url = "/ocr/idcard/front";
        JSONObject reqJson = new JSONObject();

        // 构造数据
        String filepath = "D:\\test\\test模板.png";
        File file = new File(filepath);
        InputStream input = new FileInputStream(file);
        reqJson.put("image", Base64.getEncoder().encodeToString(IOUtils.toByteArray(input)));
        reqJson.put("needFileInfo", false);

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }
}
