package com.esv.freight.file.common.util;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.boot.test.context.SpringBootTest;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

/**
 * @description:
 * @project: freight-file-service
 * @name: com.esv.freight.file.common.util.FileUtilsTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/10 11:14
 * @version:1.0
 */
@SpringBootTest
@Slf4j
public class FileUtilsTest {

    private static Long TEST_START_TIME;
    private static Long TEST_END_TIME;

    @Before
    public void before() {
        log.info("=================================== Test Start ===================================");
        TEST_START_TIME = System.currentTimeMillis();
    }

    @After
    public void after() {
        TEST_END_TIME = System.currentTimeMillis();
        log.info("Test耗时：" + (TEST_END_TIME - TEST_START_TIME) + "毫秒");
        log.info("=================================== Test End ===================================");
    }

    @Test
    public void isValidImageTest() throws IOException {
        File file1 = FileUtils.getFile("D:\\test\\路上跑-签名.PNG");
        File file2 = FileUtils.getFile("D:\\test\\test.txt");

        BufferedImage bufferedImage = ImageIO.read(file1);
        if (null == bufferedImage) {
            log.info("file1不是有效图片文件");
        } else {
            log.info("file1是有效图片文件");
        }

        bufferedImage = ImageIO.read(file2);
        if (null == bufferedImage) {
            log.info("file2不是有效图片文件");
        } else {
            log.info("file2是有效图片文件");
        }
    }
}
