package com.esv.freight.file.common.component;

import com.esv.freight.file.common.constants.TianRangOcrConstants;
import com.esv.freight.file.common.util.InputStreamUtils;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

/**
 * @description:
 * @project: freight-file-service
 * @name: com.esv.freight.file.common.component.TianRangOcrComponentTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/28 15:04
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
public class TianRangOcrComponentTest {

    @Autowired
    private TianRangOcrComponent tianRangOcrComponent;

    @Test
    public void a1_ocr_collection_test() throws Exception {
        ID_CARD_front_test();
        ID_CARD_back_test();
        JIASHIZHENG_test();
        XINGSHIZHENG_test();
        BUSINESS_LICENCE_test();
        DAOLU_YUNSHU_test();
        DAOLU_JINGYING_test();
        DAOLU_CONGYE_test();
    }

    public void ID_CARD_front_test() throws Exception {
        log.info("---------- 身份证正面 ----------");
        // 构造数据
        String filepath = "E:\\SVN\\04.项目库\\05.网络货运平台\\天壤智能-测试\\黄朝斌_身份证_头像.jpg";
        File file = new File(filepath);
        InputStream input = new FileInputStream(file);
        byte[] bytes = InputStreamUtils.inputStream2byte(input);

        String result = tianRangOcrComponent.ocr(TianRangOcrConstants.ID_CARD, bytes);
        log.info(result);
        log.info("---------- 身份证正面 ----------");
    }

    public void ID_CARD_back_test() throws Exception {
        log.info("---------- 身份证背面 ----------");
        // 构造数据
        String filepath = "E:\\SVN\\04.项目库\\05.网络货运平台\\天壤智能-测试\\黄朝斌_身份证_国徽.jpg";
        File file = new File(filepath);
        InputStream input = new FileInputStream(file);
        byte[] bytes = InputStreamUtils.inputStream2byte(input);

        String result = tianRangOcrComponent.ocr(TianRangOcrConstants.ID_CARD, bytes);
        log.info(result);
        log.info("---------- 身份证背面 ----------");
    }

    public void JIASHIZHENG_test() throws Exception {
        log.info("---------- 驾驶证 ----------");
        // 构造数据
        String filepath = "E:\\SVN\\04.项目库\\05.网络货运平台\\天壤智能-测试\\黄朝斌_驾驶证.jpg";
        File file = new File(filepath);
        InputStream input = new FileInputStream(file);
        byte[] bytes = InputStreamUtils.inputStream2byte(input);

        String result = tianRangOcrComponent.ocr(TianRangOcrConstants.JIASHIZHENG, bytes);
        log.info(result);
        log.info("---------- 驾驶证 ----------");
    }

    public void XINGSHIZHENG_test() throws Exception {
        log.info("---------- 行驶证 ----------");
        // 构造数据
        String filepath = "E:\\SVN\\04.项目库\\05.网络货运平台\\天壤智能-测试\\黄朝斌_行驶证.jpg";
        File file = new File(filepath);
        InputStream input = new FileInputStream(file);
        byte[] bytes = InputStreamUtils.inputStream2byte(input);

        String result = tianRangOcrComponent.ocr(TianRangOcrConstants.XINGSHIZHENG, bytes);
        log.info(result);
        log.info("---------- 行驶证 ----------");
    }

    public void BUSINESS_LICENCE_test() throws Exception {
        log.info("---------- 营业执照 ----------");
        // 构造数据
        String filepath = "E:\\SVN\\04.项目库\\05.网络货运平台\\天壤智能-测试\\苏州英思唯智能科技有限公司-营业执照.jpg";
        File file = new File(filepath);
        InputStream input = new FileInputStream(file);
        byte[] bytes = InputStreamUtils.inputStream2byte(input);

        String result = tianRangOcrComponent.ocr(TianRangOcrConstants.BUSINESS_LICENCE, bytes);
        log.info(result);
        log.info("---------- 营业执照 ----------");
    }

    public void DAOLU_YUNSHU_test() throws Exception {
        log.info("---------- 道路运输证 ----------");
        // 构造数据
        String filepath = "E:\\SVN\\04.项目库\\05.网络货运平台\\天壤智能-测试\\道路运输证.jpg";
        File file = new File(filepath);
        InputStream input = new FileInputStream(file);
        byte[] bytes = InputStreamUtils.inputStream2byte(input);

        String result = tianRangOcrComponent.ocr(TianRangOcrConstants.DAOLU_YUNSHU, bytes);
        log.info(result);
        log.info("---------- 道路运输证 ----------");
    }

    public void DAOLU_JINGYING_test() throws Exception {
        log.info("---------- 道路运输经营许可证 ----------");
        // 构造数据
        String filepath = "E:\\SVN\\04.项目库\\05.网络货运平台\\天壤智能-测试\\道路运输经营许可证.jpg";
        File file = new File(filepath);
        InputStream input = new FileInputStream(file);
        byte[] bytes = InputStreamUtils.inputStream2byte(input);

        String result = tianRangOcrComponent.ocr(TianRangOcrConstants.DAOLU_JINGYING, bytes);
        log.info(result);
        log.info("---------- 道路运输经营许可证 ----------");
    }

    public void DAOLU_CONGYE_test() throws Exception {
        log.info("---------- 道路运输从业资格证 ----------");
        // 构造数据
        String filepath = "E:\\SVN\\04.项目库\\05.网络货运平台\\天壤智能-测试\\道路运输从业资格证.jpeg";
        File file = new File(filepath);
        InputStream input = new FileInputStream(file);
        byte[] bytes = InputStreamUtils.inputStream2byte(input);

        String result = tianRangOcrComponent.ocr(TianRangOcrConstants.DAOLU_CONGYE, bytes);
        log.info(result);
        log.info("---------- 道路运输从业资格证 ----------");
    }
}
