package com.esv.freight.file.module.file.controller;

import com.esv.freight.file.common.exception.EException;
import com.esv.freight.file.common.response.EResponse;
import com.esv.freight.file.common.validator.groups.ValidatorInsert;
import com.esv.freight.file.module.file.form.FileForm;
import com.esv.freight.file.module.file.service.FileMetaService;
import com.esv.freight.file.module.file.service.FileService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 文件上传Controller
 * @project: freight-file-service
 * @name: com.esv.freight.file.module.upload.controller.UploadController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/14 13:36
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/upload")
public class UploadController {

    private FileMetaService fileMetaService;
    private FileService fileService;

    @Autowired
    public UploadController(FileMetaService fileMetaService, FileService fileService) {
        this.fileMetaService = fileMetaService;
        this.fileService = fileService;
    }

    /**
     * description 上传单个文件
     * param [fileForm]
     * return com.esv.freight.file.common.response.EResponse
     * author Administrator
     * createTime 2020/04/14 15:09
     **/
    @PostMapping("/single")
    public EResponse uploadSingleFile(@RequestBody @Validated(ValidatorInsert.class) FileForm fileForm) throws EException {
        // 校验文件类型及大小
        fileService.checkFile(fileForm);

        return EResponse.ok(fileMetaService.uploadFile(fileForm));
    }

}
