package com.esv.freight.file.module.file.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.file.common.response.EResponse;
import com.esv.freight.file.common.validator.groups.ValidatorDetail;
import com.esv.freight.file.module.file.form.FileForm;
import com.esv.freight.file.module.file.service.FileMetaService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

/**
 * @description: 文件下载Controller
 * @project: freight-file-service
 * @name: DownloadController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/14 17:06
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/download")
public class DownloadController {

    private FileMetaService fileMetaService;

    @Autowired
    public DownloadController(FileMetaService fileMetaService) {
        this.fileMetaService = fileMetaService;
    }

    /**
     * description 文件下载
     * param [id, response]
     * return com.esv.freight.file.common.response.EResponse
     * author Administrator
     * createTime 2020/04/14 17:25
     **/
    @GetMapping("/direct/{id}")
    public void directDownload(@PathVariable("id") String id, HttpServletResponse response) {
        fileMetaService.directDownload(id, response);
    }

    /**
     * description 获取文件数据
     * param [fileForm]
     * return com.esv.freight.file.common.response.EResponse
     * author Administrator
     * createTime 2020/04/14 20:33
     **/
    @PostMapping("/getFileData")
    public EResponse getFileData(@RequestBody @Validated(ValidatorDetail.class) FileForm fileForm) {
        String fileData = fileMetaService.getFileData(fileForm);
        JSONObject data = new JSONObject();
        data.put("fileData", fileData);

        return EResponse.ok(data);
    }
}
