package com.esv.freight.file.common.util;

import lombok.extern.slf4j.Slf4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * @description: InputStream工具类
 * @project: freight-file-service
 * @name: com.esv.freight.file.common.util.InputStreamUtils
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/28 15:10
 * @version:1.0
 */
@Slf4j
public class InputStreamUtils {

    /**
     * description byte数组转InputStream
     * param [bytes]
     * return java.io.InputStream
     * author Administrator
     * createTime 2020/05/21 19:14
     **/
    public static InputStream byte2InputStream(byte[] bytes) {
        return new ByteArrayInputStream(bytes);
    }

    /**
     * description InputStream转byte数组
     * param [inputStream]
     * return byte[]
     * author Administrator
     * createTime 2020/05/21 19:15
     **/
    public static byte[] inputStream2byte(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        try {
            while ((rc = inputStream.read(buff, 0, 100)) > 0) {
                byteArrayOutputStream.write(buff, 0, rc);
            }
        } catch (IOException e) {
            log.error(e.getMessage(), e);
        }

        return byteArrayOutputStream.toByteArray();
    }
}
