package com.esv.freight.customer.module.pay.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.esv.freight.customer.module.pay.entity.CustomerUnionpayOrderEntity;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 客户银联支付订单表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-06-03 14:45:31
 */
@Mapper
public interface CustomerUnionpayOrderDao extends BaseMapper<CustomerUnionpayOrderEntity> {

    /**
     * description 通过账单号查询支付订单记录
     * param [billId]
     * return List<CustomerPayOrderEntity>
     * author HuangChaobin
     * createTime 2020/06/03 9:27
     **/
    List<CustomerUnionpayOrderEntity> selectByBillId(String billId);
	
}
