package com.esv.freight.customer.module.contract.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.customer.common.vo.PageResultVO;
import com.esv.freight.customer.module.contract.entity.ContractOnlineRecordEntity;
import com.esv.freight.customer.module.contract.form.BlockChainForm;
import com.esv.freight.customer.module.contract.form.ContractOnlineRecordQueryForm;
import com.esv.freight.customer.module.contract.form.ContractOnlineRecordSignDriverForm;
import com.esv.freight.customer.module.contract.form.ContractOnlineRecordSignGoodsOwnerForm;
import com.esv.freight.customer.module.contract.vo.BlockChainVO;
import com.esv.freight.customer.module.contract.vo.ContractOnlineRecordSignDriverVO;
import com.esv.freight.customer.module.contract.vo.ContractOnlineRecordSignGoodsOwnerVO;
import com.esv.freight.customer.module.contract.vo.ContractOnlineRecordVO;

/**
 * 线上电子合同记录表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-05-21 15:55:34
 */
public interface ContractOnlineRecordService extends IService<ContractOnlineRecordEntity> {

    /**
     * description 货主与平台的电子合同-货主签订
     * param [form]
     * return com.esv.freight.customer.module.contract.vo.ContractOnlineRecordSignGoodsOwnerVO
     * author Administrator
     * createTime 2020/05/21 18:01
     **/
    ContractOnlineRecordSignGoodsOwnerVO goodsOwnerSign(ContractOnlineRecordSignGoodsOwnerForm form);

    /**
     * description 司机与平台的电子合同-司机签订
     * param [form]
     * return com.esv.freight.customer.module.contract.vo.ContractOnlineRecordSignDriverVO
     * author Administrator
     * createTime 2020/05/26 15:03
     **/
    ContractOnlineRecordSignDriverVO driverSign(ContractOnlineRecordSignDriverForm form);

    /**
     * description 根据合同编号获取合同信息
     * param [contractNumber]
     * return com.esv.freight.customer.module.contract.vo.ContractOnlineRecordVO
     * author Administrator
     * createTime 2020/05/22 16:54
     **/
    ContractOnlineRecordVO getContractInfoByNumber(String contractNumber);

    /**
     * description 电子合同-平台签订
     * param [contractNumber]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/05/25 9:41
     **/
    Integer platformSign(String contractNumber);

    /**
     * description 分页查询合同列表
     * param [queryForm]
     * return com.esv.freight.customer.common.vo.PageResultVO
     * author Administrator
     * createTime 2020/05/28 9:52
     **/
    PageResultVO getContractList(ContractOnlineRecordQueryForm queryForm);

    void blockChain(BlockChainForm form);

    BlockChainVO getBlockChain(BlockChainForm form);

}

