package com.esv.freight.customer.module.driver.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.customer.common.component.ErrorMessageComponent;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.module.driver.dao.DriverInfoDao;
import com.esv.freight.customer.module.driver.entity.DriverInfoEntity;
import com.esv.freight.customer.module.driver.form.AccountScoreForm;
import com.esv.freight.customer.module.driver.service.DriverInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service("driverInfoService")
public class DriverInfoServiceImpl extends ServiceImpl<DriverInfoDao, DriverInfoEntity> implements DriverInfoService {

    private ErrorMessageComponent errorMessageComponent;

    @Autowired
    public DriverInfoServiceImpl(ErrorMessageComponent errorMessageComponent) {
        this.errorMessageComponent = errorMessageComponent;
    }

    @Override
    public Integer updateOverallScore(AccountScoreForm form) {
        DriverInfoEntity dbEntity = this.baseMapper.selectOne(new LambdaQueryWrapper<DriverInfoEntity>().eq(DriverInfoEntity::getDriverId, form.getId()));
        if (null == dbEntity) {
            throw new EException(1001, errorMessageComponent.getCarrierDriverScoreOverallUpdate1001());
        }

        DriverInfoEntity entity = new DriverInfoEntity();
        entity.setId(dbEntity.getId());
        entity.setOverallScore(form.getScore());
        return this.baseMapper.updateById(entity);
    }
}