package com.esv.freight.customer.schedule;

import lombok.extern.slf4j.Slf4j;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.schedule.UnionpayTaskTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/12 17:01
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class UnionpayTaskTest {

    @Autowired
    private UnionpayTask unionpayTask;

    /**
     * 对账单定时任务触发器
     **/
    @Test
    public void a1_getStatementTaskTrigger_test() throws Exception {
        unionpayTask.getStatementTaskTrigger();
    }

    /**
     * 银联加密公钥更新
     **/
    @Test
    public void b1_updateCertTaskTrigger_test() throws Exception {
        unionpayTask.updateCertTaskTrigger();
    }
}
