package com.esv.freight.customer.common.unionpay;

import com.esv.freight.customer.BaseTestController;
import com.esv.freight.customer.common.pojo.AppUnionPayOrderReq;
import lombok.extern.slf4j.Slf4j;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.unionpay.UnionPayComponentTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/30 15:00
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class UnionPayComponentTest extends BaseTestController {

    @Autowired
    UnionPayComponent unionPayComponent;

    @Test
    public void a1_createAppUnionPayOrder_test() throws Exception {
        AppUnionPayOrderReq appUnionPayOrderReq = new AppUnionPayOrderReq();
        appUnionPayOrderReq.setMerId("777290058182031");
        appUnionPayOrderReq.setBillId("DD" + System.currentTimeMillis());
        appUnionPayOrderReq.setTxnAmt(100L);
        appUnionPayOrderReq.setBillDesc("测试订单");

        unionPayComponent.createAppUnionPayOrder(appUnionPayOrderReq);
    }
}
