package com.esv.freight.customer.common.util;

import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

/**
 * @description: Http响应工具类
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.util.ResUtils
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/02 19:26
 * @version:1.0
 */
@Slf4j
public class ResUtils {

    /**
     * description Http响应
     * param [response, status, contentType, resContent]
     * return void
     * author HuangChaobin
     * createTime 2020/06/02 19:27
     **/
    public static void response(HttpServletResponse response, int status, String contentType, String resContent) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType(contentType);
        response.setStatus(status);
        OutputStreamWriter osw = null;
        PrintWriter writer = null;
        try {
            osw = new OutputStreamWriter(response.getOutputStream(), "UTF-8");
            writer = new PrintWriter(osw, true);
            writer.write(resContent);
            writer.flush();
            osw.close();
        } catch (IOException e) {
            log.error(e.getMessage(), e);
        } finally {
            if (null != writer) {
                writer.close();
            }
            if (null != osw) {
                try {
                    osw.close();
                } catch (IOException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
    }

}
