package com.esv.freight.customer.module.servlet;

import com.esv.freight.customer.common.constants.SDKConstants;
import com.esv.freight.customer.common.unionpay.AcpService;
import com.esv.freight.customer.common.unionpay.DemoBase;
import com.esv.freight.customer.common.util.ResUtils;
import com.esv.freight.customer.module.pay.entity.CustomerUnionpayOrderEntity;
import com.esv.freight.customer.module.pay.service.UnionpayOrderService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.servlet.UnionpayBackRcvServlet
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/02 19:35
 * @version:1.0
 */
@Slf4j
public class UnionpayBackRcvServlet extends HttpServlet {

    @Autowired
    private UnionpayOrderService unionpayOrderService;

    /**
     * description 银联异步通知支付结果
     * param [req, resp]
     * return void
     * author HuangChaobin
     * createTime 2020/06/02 19:40
     **/
    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        log.info("[银联开放平台]接收后台通知开始");

        // 获取银联通知服务器发送的后台通知参数
        Map<String, String> reqParam = getAllRequestParamStream(req);

        //重要！验证签名前不要修改reqParam中的键值对的内容，否则会验签不过
        boolean validateResult = AcpService.validate(reqParam, reqParam.get(SDKConstants.param_encoding));
        if (!validateResult) {
            log.error("[银联开放平台]验证签名结果：失败");
        } else {
            log.info("[银联开放平台]验证签名结果：成功");
            //判断respCode=00、A6后，对涉及资金类的交易，请再发起查询接口查询，确定交易成功后更新数据库。
            String respCode = reqParam.get("respCode");
            if ("00".equals(respCode) || "A6".equals(respCode)) {
                String orderId = reqParam.get("orderId");
                CustomerUnionpayOrderEntity customerUnionPayOrderEntity = unionpayOrderService.getRecordByBillId(orderId);
                if (null == customerUnionPayOrderEntity) {
                    log.error("[银联开放平台]该账单号[" + orderId + "]不存在");
                } else {
                    unionpayOrderService.queryOrderStatus2Unionpay(customerUnionPayOrderEntity);
                }
            }
        }

        log.info("[银联开放平台]接收后台通知结束");

        //返回给银联服务器http 200  状态码
        ResUtils.response(resp, HttpServletResponse.SC_OK, "text/plain;charset=utf-8", "ok");
    }

    /**
     * 获取请求参数中所有的信息。
     * 非struts可以改用此方法获取，好处是可以过滤掉request.getParameter方法过滤不掉的url中的参数。
     * struts可能对某些content-type会提前读取参数导致从inputstream读不到信息，所以可能用不了这个方法。理论应该可以调整struts配置使不影响，但请自己去研究。
     * 调用本方法之前不能调用req.getParameter("key");这种方法，否则会导致request取不到输入流。
     * @param request
     * @return
     */
    private Map<String, String> getAllRequestParamStream(final HttpServletRequest request) {
        Map<String, String> res = new HashMap<>(32);
        try {
            String notifyStr = new String(IOUtils.toByteArray(request.getInputStream()), DemoBase.encoding);
            log.info("[银联开放平台]收到通知报文：" + notifyStr);
            String[] kvs = notifyStr.split("&");
            for (String kv : kvs) {
                String[] tmp = kv.split("=");
                if (tmp.length >= 2) {
                    String key = tmp[0];
                    String value = URLDecoder.decode(tmp[1], DemoBase.encoding);
                    res.put(key, value);
                }
            }
        } catch (Exception e) {
            log.error("[银联开放平台]报文解析出错: {}", e.getMessage(), e);
        }
        return res;
    }
}
