package com.esv.freight.customer.common.util;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;

import java.util.Iterator;
import java.util.Map;

/**
 * @description: Map工具类
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.util.MapUtils
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/02 16:04
 * @version:1.0
 */
@Slf4j
public class MapUtils {

    /**
     * description Map转Json
     * param [map]
     * return com.alibaba.fastjson.JSONObject
     * author HuangChaobin
     * createTime 2020/06/02 16:04
     **/
    public static JSONObject map2Json(Map<String, String> map) {
        JSONObject json = new JSONObject();
        Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> en = it.next();
            json.put(en.getKey(), en.getValue());
        }
        return json;
    }
}
