package com.esv.freight.customer.module.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.EResponse;
import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import com.esv.freight.customer.common.validator.groups.ValidatorList;
import com.esv.freight.customer.common.validator.groups.ValidatorUpdate;
import com.esv.freight.customer.module.contract.form.ContractOfflineCarrierForm;
import com.esv.freight.customer.module.contract.form.ContractOfflineCarrierQueryForm;
import com.esv.freight.customer.module.contract.service.ContractOfflineCarrierService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.controller.ContractOfflineCarrierController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/20 15:50
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/contract/offline/carrier")
@Validated
public class ContractOfflineCarrierController {

    private ContractOfflineCarrierService contractOfflineCarrierService;

    @Autowired
    public ContractOfflineCarrierController(ContractOfflineCarrierService contractOfflineCarrierService) {
        this.contractOfflineCarrierService = contractOfflineCarrierService;
    }

    /**
     * description 承运商合同-增加
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/05/20 15:52
     **/
    @PostMapping("/add")
    public EResponse add(@RequestBody @Validated(ValidatorInsert.class) ContractOfflineCarrierForm form) throws EException {
        Long id = contractOfflineCarrierService.addOfflineContract(form);
        JSONObject data = new JSONObject();
        data.put("id", id);
        return EResponse.ok(data);
    }

    /**
     * description 承运商合同-编辑
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/05/20 15:52
     **/
    @PostMapping("/edit")
    public EResponse edit(@RequestBody @Validated(ValidatorUpdate.class) ContractOfflineCarrierForm form) throws EException {
        contractOfflineCarrierService.editOfflineContract(form);
        return EResponse.ok();
    }

    /**
     * description 承运商合同-删除
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/05/20 15:53
     **/
    @PostMapping("/delete")
    public EResponse delete(@RequestBody @Validated(ValidatorUpdate.class) ContractOfflineCarrierForm form) throws EException {
        contractOfflineCarrierService.deleteOfflineContract(form);
        return EResponse.ok();
    }

    /**
     * description 承运商合同-分页查询
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/05/20 15:54
     **/
    @PostMapping("/list")
    public EResponse list(@RequestBody @Validated(ValidatorList.class) ContractOfflineCarrierQueryForm form) throws EException {
        return EResponse.ok(contractOfflineCarrierService.selectContractList(form));
    }
}
