package com.esv.freight.customer.module.goodsowner.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.util.FeignUtils;
import com.esv.freight.customer.feign.FeignBaseService;
import com.esv.freight.customer.module.goodsowner.dao.AccountDao;
import com.esv.freight.customer.module.goodsowner.entity.AccountEntity;
import com.esv.freight.customer.module.goodsowner.entity.InfoEntity;
import com.esv.freight.customer.module.goodsowner.form.AccountInfoForm;
import com.esv.freight.customer.module.goodsowner.service.AccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


@Service("accountService")
public class AccountServiceImpl extends ServiceImpl<AccountDao, AccountEntity> implements AccountService {

    private FeignBaseService feignBaseService;

    @Autowired
    public AccountServiceImpl(FeignBaseService feignBaseService) {
        this.feignBaseService = feignBaseService;
    }

    @Override
    public AccountEntity getAccountRecordByAccount(String account) {
        AccountEntity queryEntity = new AccountEntity();
        queryEntity.setAccount(account);
        QueryWrapper<AccountEntity> queryWrapper = new QueryWrapper<>(queryEntity);
        return this.baseMapper.selectOne(queryWrapper);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int createAccountByManager(AccountInfoForm form) {
        // 1.判断帐号是否已存在
        AccountEntity accountEntity = this.getAccountRecordByAccount(form.getAccount());
        if (null != accountEntity) {
            throw new EException(1001, "帐号已存在");
        } else {
            accountEntity = new AccountEntity();
        }

        // 2.获取客户编码
        JSONObject batchIdReqJson = new JSONObject();
        batchIdReqJson.put("prefix", "HZ");
        batchIdReqJson.put("formatter", "yyyyMMdd");
        batchIdReqJson.put("length", 13);
        JSONObject batchIdResJson;
        try {
            batchIdResJson = FeignUtils.getFeignResultData(feignBaseService.getBatchId(batchIdReqJson));
        } catch (Exception e) {
            log.error("调用[基础服务]生成客户编号失败");
            throw new EException("生成客户编号时发生错误");
        }
        String ownerNumber = batchIdResJson.getString("batchId");

        // 3.新增帐号

        // 4.新增帐号信息
        InfoEntity infoEntity = new InfoEntity();
        infoEntity.setOwnerNumber(ownerNumber);

        // 5.新增帐号审核记录

        return 0;
    }
}