package com.esv.freight.customer.config.mybatis;

import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantSqlParser;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @project: freight-notice-service
 * @name: com.esv.freight.customer.config.mybatis.MybatisPlusConfig
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 13:30
 * @version:1.0
 */
@Configuration
@MapperScan({"com.esv.freight.customer.*.*.dao"})
public class MybatisPlusConfig {

    /**
     * description 多租户分页插件
     * param []
     * return com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor
     * author Administrator
     * createTime 2020/04/17 14:56
     **/
    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        List<ISqlParser> sqlParserList = new ArrayList<>();
        TenantSqlParser tenantSqlParser = new DataPermParser();
        tenantSqlParser.setTenantHandler(new DataPermHandler());

        sqlParserList.add(tenantSqlParser);
        paginationInterceptor.setSqlParserList(sqlParserList);

        return paginationInterceptor;
    }
}
