package com.esv.freight.customer.module.goodsowner.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.BaseTestController;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.module.goodsowner.GoodsOwnerConstants;
import com.esv.freight.customer.module.goodsowner.form.AccountInfoForm;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.controller.GoodsOwnerControllerTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 14:37
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class GoodsOwnerControllerTest extends BaseTestController {

    @Test
    public void a1_createAccountByManager_personal_success_test() throws Exception {
        String url = "/goodsowner/account/add";

        // 构造数据
        JSONObject reqJson = new JSONObject();
        AccountInfoForm form = new AccountInfoForm();
        form.setAccount("18524431581");
        form.setPassword("e28bec3e2feb42598b8cf1a1d3b11f4a");
        form.setOwnerType(GoodsOwnerConstants.OWNER_TYPE_PERSONAL);
        form.setContactor("黄朝斌");
        form.setIdCard("360721198712031234");
        form.setIdCardExpireDate("2030/12/31");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210102");
        form.setDetailAddress("双园路");
        form.setIdCardFrontUrl("http://127.0.0.1/001.jpg");
        form.setIdCardBackUrl("http://127.0.0.1/002.jpg");
        reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    @Test
    public void a1_createAccountByManager_company_success_test() throws Exception {
        String url = "/goodsowner/account/add";

        // 构造数据
        JSONObject reqJson = new JSONObject();
        AccountInfoForm form = new AccountInfoForm();
        form.setAccount("18524431582");
        form.setPassword("e28bec3e2feb42598b8cf1a1d3b11f4a");
        form.setOwnerType(GoodsOwnerConstants.OWNER_TYPE_COMPANY);
        form.setContactor("黄朝斌");
        form.setIdCard("360721198712031234");
        form.setIdCardExpireDate("2030/12/31");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210102");
        form.setDetailAddress("双园路");
        form.setIdCardFrontUrl("http://127.0.0.1/001.jpg");
        form.setIdCardBackUrl("http://127.0.0.1/002.jpg");
        form.setOwnerFullName("黄朝斌测试有限公司");
        form.setUniCreditCode("123456789");
        form.setCreditCopyUrl("http://127.0.0.1/003.jpg");
        form.setLegalPerson("黄卓越");
        reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }
}
