package com.esv.freight.customer.module.pay.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.customer.module.pay.entity.CustomerUnionpayOrderEntity;
import com.esv.freight.customer.module.pay.form.CustomerPayOrderForm;

import java.util.List;

/**
 * 货主支付订单表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-05-30 13:41:51
 */
public interface UnionpayOrderService extends IService<CustomerUnionpayOrderEntity> {

    /**
     * description 通过账单号查询记录
     * param [billId]
     * return com.esv.freight.customer.module.pay.entity.GoodsOwnerPayOrderEntity
     * author HuangChaobin
     * createTime 2020/06/02 15:48
     **/
    CustomerUnionpayOrderEntity getRecordByBillId(String billId);

    /**
     * description 通过订单流水号查询记录
     * param [tn]
     * return com.esv.freight.customer.module.pay.entity.CustomerUnionpayOrderEntity
     * author HuangChaobin
     * createTime 2020/06/03 19:38
     **/
    CustomerUnionpayOrderEntity getRecordByTn(String tn);

    /**
     * description 创建客户支付订单
     * param [form]
     * return java.lang.String
     * author HuangChaobin
     * createTime 2020/06/03 9:38
     **/
    String createCustomerPayOrder(CustomerPayOrderForm form);

    /**
     * description 通过订单流水号查询订单支付状态
     * param [tn]
     * return java.lang.Integer
     * author HuangChaobin
     * createTime 2020/06/03 10:58
     **/
    Integer getOrderStatusByTn(String tn);

    /**
     * description 通过账单号查询订单支付状态
     * param [billId]
     * return java.lang.Integer
     * author HuangChaobin
     * createTime 2020/06/03 11:01
     **/
    Integer getOrderStatusByBillId(String billId);

    /**
     * description 请求银联查询订单支付状态
     * param [customerUnionPayOrderEntity]
     * return java.lang.Integer
     * author HuangChaobin
     * createTime 2020/06/04 9:44
     **/
    Integer queryOrderStatus2Unionpay(CustomerUnionpayOrderEntity customerUnionPayOrderEntity);

}

