package com.esv.freight.customer.common.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.common.util.ReqUtils;
import com.esv.gateway.common.GatewayHeaders;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

/**
 * @description: Feign请求拦截器
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.interceptor.FeignRequestInterceptor
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/11 9:17
 * @version:1.0
 */
@Slf4j
@Component
public class FeignRequestInterceptor implements RequestInterceptor {

    @Value("${spring.application.name}")
    private String applicationName;

    @Override
    public void apply(RequestTemplate requestTemplate) {
        requestTemplate.header("trace_id", MDC.get("traceId"));
        requestTemplate.header("application_name", applicationName);

        Class cls = GatewayHeaders.class;
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; i++) {
            Field f = fields[i];
            f.setAccessible(true);
            String key;
            try {
                key = String.valueOf(f.get(cls));
                requestTemplate.header(key, ReqUtils.getRequestHeader(key));
            } catch (IllegalAccessException e) {
                log.error(e.getMessage(), e);
            }
        }

        // 判断header是否有租户信息
        boolean isTenant = false;
        Map<String, Collection<String>> headers = requestTemplate.headers();
        for (Map.Entry<String, Collection<String>> entry : headers.entrySet()) {
            if (GatewayHeaders.TENANT_ID.equals(entry.getKey())) {
                isTenant = true;
                break;
            }
        }
        // 设置租户信息及数据权限（0-全部;1-租户;2-部门）
        if (!isTenant) {
            byte[] bytes = requestTemplate.requestBody().asBytes();
            if (null == bytes) {
                requestTemplate.header(GatewayHeaders.DATA_PERM, "0");
            } else {
                String bodyStr = new String(bytes);
                JSONObject bodyJson = JSONObject.parseObject(bodyStr);
                if (!bodyJson.isEmpty() && bodyJson.containsKey(GatewayHeaders.TENANT_ID)) {
                    requestTemplate.header(GatewayHeaders.TENANT_ID, bodyJson.getString(GatewayHeaders.TENANT_ID));
                    requestTemplate.header(GatewayHeaders.DATA_PERM, "1");
                    bodyJson.remove(GatewayHeaders.TENANT_ID);
                    bodyStr = bodyJson.toJSONString();
                    requestTemplate.body(Request.Body.encoded(bodyStr.getBytes(requestTemplate.requestCharset()), requestTemplate.requestCharset()));
                } else {
                    requestTemplate.header(GatewayHeaders.DATA_PERM, "0");
                }
            }
        }
    }
}
