package com.esv.freight.customer.module.driver.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.vo.DriverVehicleListVO
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/29 16:52
 * @version:1.0
 */
@Data
public class DriverVehicleListVO {

    /**
     *
     */
    private Long id;
    /**
     * 车牌号
     */
    private String licenseNumber;
    /**
     * 车辆状态：1-正常、2-停用
     */
    private Integer vehicleStatus;
    /**
     * 审核状态(字典表)：0-待审核、1-审核成功，2-审核失败
     */
    private Integer auditStatus;
    /**
     * 创建来源：1-平台创建、2-司机创建
     */
    private Integer sourceType;
    /**
     * 是否默认车辆：0-不是、1-是
     */
    private Integer selected;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
