package com.esv.freight.customer.common.filter;

import com.esv.freight.customer.common.response.EResponse;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.*;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

/**
 * @description: 权限过滤器
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.filter.AuthFilter
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/23 14:11
 * @version:1.0
 */
@Slf4j
public class AuthFilter implements Filter {

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
//        HttpServletRequest request = (HttpServletRequest) servletRequest;
//        HttpServletResponse response = (HttpServletResponse) servletResponse;
//        String accessToken = request.getHeader("Union-Authorization");
//        if (StringUtils.isBlank(accessToken)) {
//            this.errorResponse(EResponse.error(ECode.TOKEN_INVALID), response);
//            return;
//        } else {
//            // 解析并校验Token
//        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    @Override
    public void destroy() {

    }

    private void errorResponse(EResponse eResponse, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        OutputStreamWriter osw = null;
        PrintWriter writer = null;
        try {
            osw = new OutputStreamWriter(response.getOutputStream(), "UTF-8");
            writer = new PrintWriter(osw, true);
            writer.write(eResponse.toString());
            writer.flush();
            osw.close();
        } catch (IOException e) {
            log.error(e.getMessage(), e);
        } finally {
            if (null != writer) {
                writer.close();
            }
            if (null != osw) {
                try {
                    osw.close();
                } catch (IOException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
    }
}
