package com.esv.freight.customer.module.goodsowner.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 货主信息表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-17 13:54:57
 */
@Data
@TableName("goods_owner_info")
public class InfoEntity implements Serializable {

	private static final long serialVersionUID = 6703178702529854078L;
	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 货主帐号ID
	 */
	private Long accountId;
	/**
	 * 货主类型：1-个人、2-企业
	 */
	private Integer ownerType;
	/**
	 * 客户编码
	 */
	private String ownerNumber;
	/**
	 * 客户名称
	 */
	private String ownerFullName;
	/**
	 * 客户简称
	 */
	private String ownerBriefName;
	/**
	 * 统一社会信用代码
	 */
	private String uniCreditCode;
	/**
	 * 营业期限
	 */
	private String creditExpireDate;
	/**
	 * 营业执照正本ULR
	 */
	private String creditOriginalUrl;
	/**
	 * 营业执照副本ULR
	 */
	private String creditCopyUrl;
	/**
	 * 企业法人姓名
	 */
	private String legalPerson;
	/**
	 * 企业法人手机号
	 */
	private String legalPhone;
	/**
	 * 省份代码
	 */
	private String provinceCode;
	/**
	 * 市代码
	 */
	private String cityCode;
	/**
	 * 区县代码
	 */
	private String districtCode;
	/**
	 * 详细地址
	 */
	private String detailAddress;
	/**
	 * （个人或企业）联系人
	 */
	private String contactor;
	/**
	 * （个人或企业）身份证号码
	 */
	private String idCard;
	/**
	 * （个人或企业）身份证有效期
	 */
	private String idCardExpireDate;
	/**
	 * 身份证正面图片URL
	 */
	private String idCardFrontUrl;
	/**
	 * 身份证背面图片URL
	 */
	private String idCardBackUrl;
	/**
	 * 综合评分
	 */
	private Integer overallScore;

}
